package com.androidbook.pettracker;

import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;

import com.androidbook.pettracker.PetTrackerDatabase.PetType;
import com.androidbook.pettracker.PetTrackerDatabase.Pets;

// Ekran danych zwierzaka.
public class PetTrackerEntryActivity extends PetTrackerActivity {
	/** Metoda wywoływana podczas pierwszego tworzenia aktywności. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.petentry);

		// Wypełnienie listy słów AutoComplete danymi z bazy
		fillAutoCompleteFromDatabase();
		
		// Obsługa przycisku Zapisz
		final Button savePet = (Button) findViewById(R.id.ButtonSave);
		savePet.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				final EditText petName = (EditText) findViewById(R.id.EditTextName);
				final EditText petType = (EditText) findViewById(R.id.EditTextSpecies);

				// Zapis nowych rekordów.
				SQLiteDatabase db = mDatabase.getWritableDatabase();
				db.beginTransaction();
				try {

				    // Sprawdzenie czy gatunek już jest w bazie.
					long rowId = 0;
					String strPetType = petType.getText().toString()
							.toLowerCase();

					// Zapytanie SQL
					SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
					queryBuilder.setTables(PetType.PETTYPE_TABLE_NAME);
					queryBuilder.appendWhere(PetType.PET_TYPE_NAME + "='"
							+ strPetType + "'");

					// Wykonanie zapytania.
					Cursor c = queryBuilder.query(db, null, null, null, null,
							null, null);

					if (c.getCount() == 0) {
						// Dodanie nowego gatunku do listy.
						ContentValues typeRecordToAdd = new ContentValues();
						typeRecordToAdd.put(PetType.PET_TYPE_NAME, strPetType);
						rowId = db.insert(PetType.PETTYPE_TABLE_NAME,
								PetType.PET_TYPE_NAME, typeRecordToAdd);
					} else {
						c.moveToFirst();
						rowId = c.getLong(c.getColumnIndex(PetType._ID));
					}

					c.close();

					// Zawsze dodajemy nowy rekord, nawet jeśli zwierzak o tym samym imieniu już istnieje.
					ContentValues petRecordToAdd = new ContentValues();
					petRecordToAdd.put(Pets.PET_NAME, petName.getText()
							.toString());
					petRecordToAdd.put(Pets.PET_TYPE_ID, rowId);
					db.insert(Pets.PETS_TABLE_NAME, Pets.PET_NAME,
							petRecordToAdd);

					db.setTransactionSuccessful();
				} finally {
					db.endTransaction();
				}

				// Przywrócenie formularza do stanu początkowego.
				petName.setText(null);
				petType.setText(null);
				db.close();

			}
		});

		// Obsługa przycisku Pokaż wszystkie zwierzaki.
		final Button gotoList = (Button) findViewById(R.id.ButtonShowPets);
		gotoList.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Przejście do innej aktywności, która wyświetli listę zwierzaków.
				Intent intent = new Intent(PetTrackerEntryActivity.this, PetTrackerListActivity.class);
				startActivity(intent);
			}
		});

	}
	
	// Ta metoda wypełnia adapter kontrolki AutoCompleteTextView gatunkami zwierzaków z bazy danych.
	// W tym przypadku używamy ręcznej metody kojarzenia danych z kursora z elementami ArrayAdapter,
	// które będą następnie wyświetlane w kontrolce AutoCompleteTextView.
	// Pokazujemy tę metodę, by Czytelnik wiedział jak można użyć prostej tablicy do wyświetlenia danych
	// w kontrolce AutoText. Jednak normalnie zawartość kontrolek ListView oraz AutoCompleteTextView
	// jest określana przy użyciu obiektów SimpleCursorAdapter oraz CursorAdapter. Niestety, w przypadku
	// kontrolki AutoCompleteTextView, wykorzystanie jednej z tych par kontrolki i adaptera wymusza,
	// by "wartość" automatycznie uzupełnianego łańcucha znaków był identyfikator elementu z bazy, a nie sam
	// łańcuch; a zatem nie działa to domyślnie tak jak można by sobie tego życzyć.
	// Najbardziej odpowiednim rozwiązaniem jest skorzystanie z techniki kojarzenia danych (ang. data-binding)
	// która wymaga zaimplementowania klas: SimpleCursorAdapter.CursorToStringConverter oraz FilterQueryProvider
	// co też przedstawiliśmy w przykładzie MediaPetTracker.
	void fillAutoCompleteFromDatabase()
	{
		SQLiteDatabase db = mDatabase.getReadableDatabase();
		Cursor c = db.query(PetType.PETTYPE_TABLE_NAME, new String[] {PetType.PET_TYPE_NAME}, null, null,
				null, null, PetType.DEFAULT_SORT_ORDER);

		int iNumberOfSpeciesTypes = c.getCount();
		String astrAutoTextOptions[] = new String[iNumberOfSpeciesTypes];
		if((iNumberOfSpeciesTypes > 0) && (c.moveToFirst()))
		{
			for(int i = 0; i < iNumberOfSpeciesTypes; i++)
			{
				astrAutoTextOptions[i] = c.getString(c.getColumnIndex(PetType.PET_TYPE_NAME));
				c.moveToNext();
			}
			
			ArrayAdapter<String> adapter =
		        new ArrayAdapter<String>(
		            this,
		            android.R.layout.simple_dropdown_item_1line,
		            astrAutoTextOptions);

				AutoCompleteTextView text = (AutoCompleteTextView) findViewById(R.id.EditTextSpecies);
				text.setAdapter(adapter);
		}

		c.close();
		db.close();
		
	}
	
}